@extends('layout')
@section('title','Products')
@section('content')
    <div class="row gx-4">
        @foreach($lottery as $lotterys)
            @if(date('Y-m-d') >= $lotterys->start_date AND date('Y-m-d') <= $lotterys->end_date)
				<div class="col-sm-4 col-12">
					<div class="card mb-4">
						<div class="card-header">
							<h5 class="card-title">{{$lotterys->lottery_name}}</h5>
						</div>
						<div class="card-body">
							<div class="card-img">
								<img src="{{$url}}/uploads/lottery/templates/{{$lotterys->template_image}}" class="img-fluid rounded-3 mb-3" alt="{{$lotterys->lottery_name}}" />
							</div>
							<a href="#" class="btn btn-warning">€{{$lotterys->price}}/-</a>
							<a href="#" class="btn btn-info">Last Date : {{$lotterys->end_date}}</a>
							<a href="#" class="btn btn-success">
								@if($lotterys->frequency == 1)
									{{'Daily'}}
								@elseif($lotterys->frequency == 2)
									{{'Weekly'}}
								@elseif($lotterys->frequency == 3)
									{{'Monthly'}}
								@elseif($lotterys->frequency == 4)
									{{'Fortnight'}}
								@else
									{{'Yearly'}}
								@endif
							</a>
						</div>
					</div>
				</div>
            @endif
        @endforeach
    </div>
	<h1>Future Lotteries</h1>
    <div class="row gx-4">
        @foreach($lottery as $lotterys)
            @if(date('Y-m-d') < $lotterys->start_date AND date('Y-m-d') <= $lotterys->end_date)
				<div class="col-sm-4 col-12">
					<div class="card mb-4">
						<div class="card-header">
							<h5 class="card-title">{{$lotterys->lottery_name}}</h5>
						</div>
						<div class="card-body">
							<div class="card-img">
								<img src="{{$url}}/uploads/lottery/templates/{{$lotterys->template_image}}" class="img-fluid rounded-3 mb-3" alt="{{$lotterys->lottery_name}}" />
							</div>
							<a href="#" class="btn btn-warning">€{{$lotterys->price}}/-</a>
							<a href="#" class="btn btn-info">Start Date : {{$lotterys->start_date}}</a>
							<a href="#" class="btn btn-success">
								@if($lotterys->frequency == 1)
									{{'Daily'}}
								@elseif($lotterys->frequency == 2)
									{{'Weekly'}}
								@elseif($lotterys->frequency == 3)
									{{'Monthly'}}
								@elseif($lotterys->frequency == 4)
									{{'Fortnight'}}
								@else
									{{'Yearly'}}
								@endif
							</a>
						</div>
					</div>
				</div>
            @endif
        @endforeach
    </div>
@endsection